/* 
 * npecli.c
 *
 * Моделює роботу клієнта, який передає запити серверу через іменований
 * канал. Запити отримує від користувача. Відповіді від сервера не
 * отримує.
 * Ілюструє порядок застосування іменованих каналів.
 *
 */

#include "npe.h"

int main()
{
        char buf[BUFSIZE];
        int pdw;

        /* Відкриває іменований канал на запис (передбачається, що сервер
           попередньо створив цей канал). */
        pdw = open(PIPE_TO_SERVER, O_WRONLY);
        if (pdw < 0) {
                perror("open(PIPE_TO_SERVER, ...)");
                exit(EXIT_FAILURE);
        }

        do {
                /* Запитує від користувача повідомлення. */
                printf("Request: ");
                scanf("%s", buf);
                /* Передає повідомлення серверу. */
                if (write(pdw, buf, BUFSIZE) < 0) {
                        perror("write()");
                        exit(EXIT_FAILURE);
                }
                buf[0] = '\0';
                sleep(1);
                /* Запитує від користувача продовження роботи. */
                printf("Another request? [y/n] ");
                scanf("%s", buf);
        } while (!(strcmp(buf, "y") * strcmp(buf, "Y") 
                        * strcmp(buf, "yes") * strcmp(buf, "Yes")));

        exit(EXIT_SUCCESS);
}
